/* <nagg05.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g05 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2157 (Feb 1998).
 * Mark 6 revised. IER-3044 (July 2000).
 */
#ifndef NAGG05
#define NAGG05

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* Note:
   * g05dgc is called by g05c{b,c,f} stringents only
   */
#include "naglg05.h"    /* Needed for Nag_ag05ca_type etc. */
#ifdef NAG_THREAD_SAFE
	#ifdef _MSC_VER		//Cheney 2006-6-7
		#include <pthread.h> 
	#endif //_MSC_VER
#endif
  /* These functions are defined in g05czzt.c, they
   * are for use by g05c* stringents.
   */
  extern  NAG_DLL_EXPIMP Nag_bg05ca_type NAG_CALL get_bg05ca(void);
  extern  NAG_DLL_EXPIMP Nag_dg05ca_type NAG_CALL get_dg05ca(void);
  /* begin proto */
  extern NAG_DLL_EXPIMP double NAG_CALL g05cac(void);
  extern double g05caf_f(double x);
  extern void g05cay_f(Boolean reinit);
  extern void g05cay(Boolean reinit);
  extern void g05caz_f(Boolean *init);
  extern NAG_DLL_EXPIMP void NAG_CALL g05caz(Boolean *init,
                                             Nag_ag05ca_type **ag05ca,
                                             Nag_bg05ca_type **bg05ca,
                                             Nag_cg05ca_type **cg05ca,
                                             Nag_dg05ca_type **dg05ca);
  extern NAG_DLL_EXPIMP void NAG_CALL g05cbc(Integer seed);
  extern void g05cbf_f(Integer i);
  extern NAG_DLL_EXPIMP void NAG_CALL g05ccc(void);
  extern NAG_DLL_EXPIMP void NAG_CALL g05cfc(Integer istate[], double xstate[]);
  extern void g05cfz(Integer *ia, double *xb);
  extern NAG_DLL_EXPIMP void NAG_CALL g05cgc(Integer istate[], double xstate[], NagError *fail);
  extern void g05cgz(Integer *ia, double *xb);
  extern NAG_DLL_EXPIMP void NAG_CALL g05cxc(void); 
  extern NAG_DLL_EXPIMP double NAG_CALL g05dac(double mu, double sd);
  extern double g05daf_f(double a, double b);
  extern NAG_DLL_EXPIMP double NAG_CALL g05dbc(double mu);
  extern NAG_DLL_EXPIMP double NAG_CALL g05ddc(double mu, double sd);
  extern double g05ddf_f(double a, double b);
  extern NAG_DLL_EXPIMP double NAG_CALL g05dfc(double a, double b);
  extern NAG_DLL_EXPIMP double NAG_CALL g05dgc(double a, double b, NagError *fail);
  extern NAG_DLL_EXPIMP Integer NAG_CALL g05drc(double alamda,  Integer *ifail);
  extern NAG_DLL_EXPIMP Integer NAG_CALL g05dyc(Integer m, Integer n);
  extern NAG_DLL_EXPIMP void NAG_CALL g05eac(double a[], Integer n, double c[], Integer tdc, 
                                             double eps, double **r,
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g05ecc(double t, double **r, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g05edc(Integer n, double p, double **r, 
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g05ehc(Integer index[], Integer n, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g05ejc(Integer ia[], Integer n, Integer iz[], Integer m, 
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g05exc(double p[], Integer np, Integer sizep, Nag_DiscreteDistrib df, 
                                             double **r, NagError *fail);
  extern void g05exz(Integer m, Integer n, double r[], Integer nr);
  extern NAG_DLL_EXPIMP Integer NAG_CALL g05eyc(double r[]);
  extern NAG_DLL_EXPIMP void NAG_CALL g05ezc(double z[], double r[]);
  extern NAG_DLL_EXPIMP void NAG_CALL g05fac(double a, double b,  Integer n,  double x[]);
  extern void g05faf_f(double a, double b, Integer n, double x[]);
  extern NAG_DLL_EXPIMP void NAG_CALL g05fdc(double a, double b, Integer n, double *x);
  extern void g05fdf_f(double a, double b, Integer n, double x[]);
  extern NAG_DLL_EXPIMP void NAG_CALL g05fec(double a, double b, Integer n, double x[],
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g05ffc(double a, double b, Integer n, double x[],
                                             NagError *fail);
  extern void g05fff_f(double a, double b, Integer n, double x[],
                       Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g05hac(Boolean start, Integer p, Integer q, double phi[],
                                             double theta[], double mean, double vara, Integer n,
                                             double w[], double ref[], NagError *fail);
  extern void g05hdz_f(Integer ip, Integer k, const double par[], double a[],
                       double rr[], double ri[], Integer intgr[], Integer kr,
                       double limit, double *bigest, Boolean *stat, Integer *ifaila);
  extern NAG_DLL_EXPIMP
  void NAG_CALL g05hkc(Integer num, Integer ip, Integer iq, const double param[],
                       double  gamma, double  ht[], double  yt[], 
                       Nag_Garch_Fcall_Type fcall, double  rvec[],
                       NagError *ifail);
  extern NAG_DLL_EXPIMP
  void NAG_CALL g05hlc(Integer num, Integer ip, Integer iq, const double param[],
                       double gamma, double ht[], double yt[], 
                       Nag_Garch_Fcall_Type fcall, double rvec[], NagError *ifail);
  extern NAG_DLL_EXPIMP
  void NAG_CALL g05hmc(Integer num, Integer ip, Integer iq, const double param[],
              double gamma, double ht[], double yt[], 
              Nag_Garch_Fcall_Type fcall, double rvec[], NagError *ifail);

  extern NAG_DLL_EXPIMP double NAG_CALL g05kac(Integer igen, Integer iseed[]); 
  
  extern NAG_DLL_EXPIMP void NAG_CALL g05kbc(Integer *igen, Integer iseed[]); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05kcc(Integer *igen, Integer iseed[]);

  extern NAG_DLL_EXPIMP Boolean NAG_CALL g05kec(double p, Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lac(double xmu, double var, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lbc(Integer df, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lcc(Integer df, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05ldc(Integer df1, Integer df2, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lec(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lfc(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lgc(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lhc(double xmin, double xmax, double xmed, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05ljc(double a, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lkc(double xmu, double var, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05llc(double xmed, double semiqr, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lmc(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lnc(double a, double b, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lpc(double vk, Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lqc(Integer nmix, const double a[], const double wgt[], Integer n, double x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05lzc(Nag_OrderType order, Integer mode, Integer n, const double xmu[], const double c[], Integer ic, double x[], Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mac(Integer a, Integer b, Integer n, Integer x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mbc(Integer mode, double p, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mcc(Integer mode, Integer m, double p, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mdc(Integer mode, double a, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mec(Integer m, const double vlamda[], Integer x[], Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mjc(Integer mode, Integer m, double p, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mkc(Integer mode, double lambda, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mlc(Integer mode, Integer ns, Integer np, Integer m, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mrc(Nag_OrderType order, Integer mode, Integer m, Integer k, const double p[], Integer n, Integer x[], Integer pdx, Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05mzc(Integer mode, const double p[], Integer np, Integer ip1, Nag_ComputeType comp_type, Integer n, Integer x[], Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05nac(Integer index[], Integer n, Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05nbc(const Integer ipop[], Integer n, Integer isampl[], Integer m, Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05pac(Integer mode, double xmean, Integer p, const double phi[], Integer q, const double theta[], double avar, double *var, Integer n, double x[], Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05pcc(Nag_OrderType order, Integer mode, Integer k, const double xmean[], Integer p, const double phi[], Integer q, const double theta[], const double var[], Integer pdv, Integer n, double x[], Integer pdx, Integer igen, Integer iseed[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05qac(Nag_OrderType order, Nag_SideType side, Nag_InitializeA init, Integer m, Integer n, double a[], Integer pda, Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05qbc(Nag_OrderType order, Integer n, const double d[], double c[], Integer pdc, double eps, Integer igen, Integer iseed[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05qdc(Nag_OrderType order, Integer mode, Integer nrow, Integer ncol, const Integer totr[], const Integer totc[], Integer x[], Integer pdx, Integer igen, Integer iseed[], double r[], Integer nr, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g05yac(Nag_QuasiRandom_State state,
              Nag_QuasiRandom_Sequence seq, Integer iskip, Integer idim, 
              double quasi[], Nag_QuasiRandom *GF, NagError *fail); 

extern void g05yan(int skip, Nag_QuasiRandom *GF, int *ierr);
extern void g05yam(Nag_QuasiRandom *GF);
extern void g05yap(Nag_QuasiRandom *GF, int *ierr);
extern void g05yar(Nag_QuasiRandom *GF, int *ierr);
extern int g05yaq(Nag_QuasiRandom *GF);
extern int g05yas(int dim,int skip, Nag_QuasiRandom *GF, int *ierr);
extern long *g05yal(Nag_QuasiRandom *GF);

  extern Integer g05yau(Integer iin, Integer jin);

  extern void g05yav(Integer px[], Integer b[], Integer v[], Integer maxv, Integer *ierr);

  extern void g05yaw(Integer pa[], Integer pb[], Integer pc[], Integer *ierr);

  extern void g05yax(Boolean fcall, Integer idim, double quasi[], 
                     Nag_QuasiRandom *GF, Integer skip, Integer *ierr);

  extern void g05yay(Boolean fcall, Integer idim, double quasi[],
                     Nag_QuasiRandom *GF, Integer skip, Integer *ierr);

  extern void g05yaz(Boolean fcall, Integer idim, double quasi[], 
                     Nag_QuasiRandom *GF, Integer *ierr);

extern void g05yat(Boolean fcall, Integer idim, double quasi[], Nag_QuasiRandom *GF,
                        Integer *ifail);

	extern NAG_DLL_EXPIMP void NAG_CALL g05ybc(Nag_QuasiRandom_State state,
     Nag_QuasiRandom_Sequence seq, Nag_Distributions dist, 
     const double mean[], const double std[], Integer iskip, Integer idim, 
     double quasi[], Nag_QuasiRandom *GF, NagError *fail); 


  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG05 */
